/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.css.parser;

import com.gargoylesoftware.css.parser.AbstractLocatable;
import com.gargoylesoftware.css.parser.LexicalUnit;
import java.io.Serializable;

public class LexicalUnitImpl
extends AbstractLocatable
implements LexicalUnit,
Serializable {
    private LexicalUnit.LexicalUnitType lexicalUnitType_;
    private LexicalUnit nextLexicalUnit_;
    private LexicalUnit previousLexicalUnit_;
    private float floatValue_;
    private String dimension_;
    private String functionName_;
    private LexicalUnit parameters_;
    private String stringValue_;
    private transient String toString_;

    public void setNextLexicalUnit(LexicalUnit next) {
        this.nextLexicalUnit_ = next;
    }

    public void setPreviousLexicalUnit(LexicalUnit prev) {
        this.previousLexicalUnit_ = prev;
    }

    public void setFloatValue(float floatVal) {
        this.floatValue_ = floatVal;
        this.toString_ = null;
    }

    public String getDimension() {
        return this.dimension_;
    }

    public void setDimension(String dimension) {
        this.dimension_ = dimension;
        this.toString_ = null;
    }

    public void setFunctionName(String function) {
        this.functionName_ = function;
        this.toString_ = null;
    }

    public void setParameters(LexicalUnit params) {
        this.parameters_ = params;
        this.toString_ = null;
    }

    public void setStringValue(String stringVal) {
        this.stringValue_ = stringVal;
        this.toString_ = null;
    }

    public LexicalUnitImpl(LexicalUnit previous, LexicalUnit.LexicalUnitType type) {
        this.lexicalUnitType_ = type;
        this.previousLexicalUnit_ = previous;
        if (this.previousLexicalUnit_ != null) {
            ((LexicalUnitImpl)this.previousLexicalUnit_).nextLexicalUnit_ = this;
        }
    }

    protected LexicalUnitImpl(LexicalUnit previous, int value) {
        this(previous, LexicalUnit.LexicalUnitType.INTEGER);
        this.floatValue_ = value;
    }

    protected LexicalUnitImpl(LexicalUnit previous, LexicalUnit.LexicalUnitType type, float value) {
        this(previous, type);
        this.floatValue_ = value;
    }

    protected LexicalUnitImpl(LexicalUnit previous, LexicalUnit.LexicalUnitType type, String dimension, float value) {
        this(previous, type);
        this.dimension_ = dimension;
        this.floatValue_ = value;
    }

    public LexicalUnitImpl(LexicalUnit previous, LexicalUnit.LexicalUnitType type, String value) {
        this(previous, type);
        this.stringValue_ = value;
    }

    protected LexicalUnitImpl(LexicalUnit previous, LexicalUnit.LexicalUnitType type, String name, LexicalUnit params) {
        this(previous, type);
        this.functionName_ = name;
        this.parameters_ = params;
    }

    protected LexicalUnitImpl(LexicalUnit previous, LexicalUnit.LexicalUnitType type, String name, String stringValue) {
        this(previous, type);
        this.functionName_ = name;
        this.stringValue_ = stringValue;
    }

    @Override
    public LexicalUnit.LexicalUnitType getLexicalUnitType() {
        return this.lexicalUnitType_;
    }

    @Override
    public LexicalUnit getNextLexicalUnit() {
        return this.nextLexicalUnit_;
    }

    @Override
    public LexicalUnit getPreviousLexicalUnit() {
        return this.previousLexicalUnit_;
    }

    @Override
    public int getIntegerValue() {
        return (int)this.floatValue_;
    }

    @Override
    public float getFloatValue() {
        return this.floatValue_;
    }

    @Override
    public String getDimensionUnitText() {
        switch (this.lexicalUnitType_) {
            case EM: {
                return "em";
            }
            case EX: {
                return "ex";
            }
            case PIXEL: {
                return "px";
            }
            case INCH: {
                return "in";
            }
            case CENTIMETER: {
                return "cm";
            }
            case MILLIMETER: {
                return "mm";
            }
            case POINT: {
                return "pt";
            }
            case PICA: {
                return "pc";
            }
            case PERCENTAGE: {
                return "%";
            }
            case DEGREE: {
                return "deg";
            }
            case GRADIAN: {
                return "grad";
            }
            case RADIAN: {
                return "rad";
            }
            case MILLISECOND: {
                return "ms";
            }
            case SECOND: {
                return "s";
            }
            case HERTZ: {
                return "Hz";
            }
            case KILOHERTZ: {
                return "kHz";
            }
            case DIMENSION: {
                return this.dimension_;
            }
        }
        return "";
    }

    @Override
    public String getFunctionName() {
        return this.functionName_;
    }

    @Override
    public LexicalUnit getParameters() {
        return this.parameters_;
    }

    @Override
    public String getStringValue() {
        return this.stringValue_;
    }

    @Override
    public LexicalUnit getSubValues() {
        return this.parameters_;
    }

    public String getCssText() {
        if (null != this.toString_) {
            return this.toString_;
        }
        StringBuilder sb = new StringBuilder();
        switch (this.lexicalUnitType_) {
            case OPERATOR_COMMA: {
                sb.append(",");
                break;
            }
            case OPERATOR_PLUS: {
                sb.append("+");
                break;
            }
            case OPERATOR_MINUS: {
                sb.append("-");
                break;
            }
            case OPERATOR_MULTIPLY: {
                sb.append("*");
                break;
            }
            case OPERATOR_SLASH: {
                sb.append("/");
                break;
            }
            case OPERATOR_MOD: {
                sb.append("%");
                break;
            }
            case OPERATOR_EXP: {
                sb.append("^");
                break;
            }
            case OPERATOR_LT: {
                sb.append("<");
                break;
            }
            case OPERATOR_GT: {
                sb.append(">");
                break;
            }
            case OPERATOR_LE: {
                sb.append("<=");
                break;
            }
            case OPERATOR_GE: {
                sb.append(">=");
                break;
            }
            case OPERATOR_TILDE: {
                sb.append("~");
                break;
            }
            case INHERIT: {
                sb.append("inherit");
                break;
            }
            case INTEGER: {
                sb.append(String.valueOf(this.getIntegerValue()));
                break;
            }
            case REAL: {
                sb.append(this.getTrimedFloatValue());
                break;
            }
            case EM: 
            case EX: 
            case PIXEL: 
            case INCH: 
            case CENTIMETER: 
            case MILLIMETER: 
            case POINT: 
            case PICA: 
            case PERCENTAGE: 
            case DEGREE: 
            case GRADIAN: 
            case RADIAN: 
            case MILLISECOND: 
            case SECOND: 
            case HERTZ: 
            case KILOHERTZ: 
            case DIMENSION: {
                sb.append(this.getTrimedFloatValue());
                String dimUnitText = this.getDimensionUnitText();
                if (null == dimUnitText) break;
                sb.append(dimUnitText);
                break;
            }
            case URI: {
                sb.append("url(").append(this.getStringValue()).append(")");
                break;
            }
            case COUNTER_FUNCTION: {
                sb.append("counter(");
                this.appendParams(sb);
                sb.append(")");
                break;
            }
            case COUNTERS_FUNCTION: {
                sb.append("counters(");
                this.appendParams(sb);
                sb.append(")");
                break;
            }
            case RGBCOLOR: {
                sb.append("rgb(");
                this.appendParams(sb);
                sb.append(")");
                break;
            }
            case IDENT: {
                sb.append(this.getStringValue());
                break;
            }
            case STRING_VALUE: {
                sb.append("\"");
                String value = this.getStringValue();
                value = value.replace("\n", "\\A ").replace("\r", "\\D ");
                sb.append(value);
                sb.append("\"");
                break;
            }
            case ATTR: {
                sb.append("attr(").append(this.getStringValue()).append(")");
                break;
            }
            case RECT_FUNCTION: {
                sb.append("rect(");
                this.appendParams(sb);
                sb.append(")");
                break;
            }
            case UNICODERANGE: {
                String range = this.getStringValue();
                if (null == range) break;
                sb.append(range);
                break;
            }
            case SUB_EXPRESSION: {
                String subExpression = this.getStringValue();
                if (null == subExpression) break;
                sb.append(subExpression);
                break;
            }
            case FUNCTION: {
                String functName = this.getFunctionName();
                if (null != functName) {
                    sb.append(functName);
                }
                sb.append('(');
                this.appendParams(sb);
                sb.append(")");
                break;
            }
        }
        this.toString_ = sb.toString();
        return this.toString_;
    }

    public String toString() {
        return this.getCssText();
    }

    public String toDebugString() {
        StringBuilder sb = new StringBuilder();
        switch (this.lexicalUnitType_) {
            case OPERATOR_COMMA: {
                sb.append("OPERATOR_COMMA");
                break;
            }
            case OPERATOR_PLUS: {
                sb.append("OPERATOR_PLUS");
                break;
            }
            case OPERATOR_MINUS: {
                sb.append("OPERATOR_MINUS");
                break;
            }
            case OPERATOR_MULTIPLY: {
                sb.append("OPERATOR_MULTIPLY");
                break;
            }
            case OPERATOR_SLASH: {
                sb.append("OPERATOR_SLASH");
                break;
            }
            case OPERATOR_MOD: {
                sb.append("OPERATOR_MOD");
                break;
            }
            case OPERATOR_EXP: {
                sb.append("OPERATOR_EXP");
                break;
            }
            case OPERATOR_LT: {
                sb.append("OPERATOR_LT");
                break;
            }
            case OPERATOR_GT: {
                sb.append("OPERATOR_GT");
                break;
            }
            case OPERATOR_LE: {
                sb.append("OPERATOR_LE");
                break;
            }
            case OPERATOR_GE: {
                sb.append("OPERATOR_GE");
                break;
            }
            case OPERATOR_TILDE: {
                sb.append("OPERATOR_TILDE");
                break;
            }
            case INHERIT: {
                sb.append("INHERIT");
                break;
            }
            case INTEGER: {
                sb.append("INTEGER(").append(String.valueOf(this.getIntegerValue())).append(")");
                break;
            }
            case REAL: {
                sb.append("REAL(").append(this.getTrimedFloatValue()).append(")");
                break;
            }
            case EM: {
                sb.append("EM(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case EX: {
                sb.append("EX(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case PIXEL: {
                sb.append("PIXEL(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case INCH: {
                sb.append("INCH(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case CENTIMETER: {
                sb.append("CENTIMETER(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case MILLIMETER: {
                sb.append("MILLIMETER(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case POINT: {
                sb.append("POINT(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case PICA: {
                sb.append("PICA(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case PERCENTAGE: {
                sb.append("PERCENTAGE(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case DEGREE: {
                sb.append("DEGREE(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case GRADIAN: {
                sb.append("GRADIAN(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case RADIAN: {
                sb.append("RADIAN(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case MILLISECOND: {
                sb.append("MILLISECOND(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case SECOND: {
                sb.append("SECOND(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case HERTZ: {
                sb.append("HERTZ(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case KILOHERTZ: {
                sb.append("KILOHERTZ(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case DIMENSION: {
                sb.append("DIMENSION(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case URI: {
                sb.append("URI(url(").append(this.getStringValue()).append("))");
                break;
            }
            case COUNTER_FUNCTION: {
                sb.append("COUNTER_FUNCTION(counter(");
                this.appendParams(sb);
                sb.append("))");
                break;
            }
            case COUNTERS_FUNCTION: {
                sb.append("COUNTERS_FUNCTION(counters(");
                this.appendParams(sb);
                sb.append("))");
                break;
            }
            case RGBCOLOR: {
                sb.append("RGBCOLOR(rgb(");
                this.appendParams(sb);
                sb.append("))");
                break;
            }
            case IDENT: {
                sb.append("IDENT(").append(this.getStringValue()).append(")");
                break;
            }
            case STRING_VALUE: {
                sb.append("STRING_VALUE(\"").append(this.getStringValue()).append("\")");
                break;
            }
            case ATTR: {
                sb.append("ATTR(attr(").append(this.getStringValue()).append("))");
                break;
            }
            case RECT_FUNCTION: {
                sb.append("RECT_FUNCTION(rect(");
                this.appendParams(sb);
                sb.append("))");
                break;
            }
            case UNICODERANGE: {
                sb.append("UNICODERANGE(").append(this.getStringValue()).append(")");
                break;
            }
            case SUB_EXPRESSION: {
                sb.append("SUB_EXPRESSION(").append(this.getStringValue()).append(")");
                break;
            }
            case FUNCTION: {
                sb.append("FUNCTION(").append(this.getFunctionName()).append("(");
                for (LexicalUnit l = this.parameters_; l != null; l = l.getNextLexicalUnit()) {
                    sb.append(l.toString());
                }
                sb.append("))");
                break;
            }
        }
        return sb.toString();
    }

    private void appendParams(StringBuilder sb) {
        LexicalUnit l = this.parameters_;
        if (l != null) {
            sb.append(l.toString());
            for (l = l.getNextLexicalUnit(); l != null; l = l.getNextLexicalUnit()) {
                if (l.getLexicalUnitType() != LexicalUnit.LexicalUnitType.OPERATOR_COMMA) {
                    sb.append(" ");
                }
                sb.append(l.toString());
            }
        }
    }

    private String getTrimedFloatValue() {
        int i;
        float f = this.getFloatValue();
        if (f - (float)(i = (int)f) == 0.0f) {
            return Integer.toString((int)f);
        }
        return Float.toString(f);
    }

    public static LexicalUnit createNumber(LexicalUnit prev, int i) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.INTEGER, i);
    }

    public static LexicalUnit createNumber(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.REAL, f);
    }

    public static LexicalUnit createPercentage(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.PERCENTAGE, f);
    }

    public static LexicalUnit createPixel(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.PIXEL, f);
    }

    public static LexicalUnit createCentimeter(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.CENTIMETER, f);
    }

    public static LexicalUnit createMillimeter(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.MILLIMETER, f);
    }

    public static LexicalUnit createInch(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.INCH, f);
    }

    public static LexicalUnit createPoint(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.POINT, f);
    }

    public static LexicalUnit createPica(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.PICA, f);
    }

    public static LexicalUnit createEm(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.EM, f);
    }

    public static LexicalUnit createEx(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.EX, f);
    }

    public static LexicalUnit createDegree(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.DEGREE, f);
    }

    public static LexicalUnit createRadian(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.RADIAN, f);
    }

    public static LexicalUnit createGradian(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.GRADIAN, f);
    }

    public static LexicalUnit createMillisecond(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.MILLISECOND, f);
    }

    public static LexicalUnit createSecond(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.SECOND, f);
    }

    public static LexicalUnit createHertz(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.HERTZ, f);
    }

    public static LexicalUnit createDimension(LexicalUnit prev, float f, String dim) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.DIMENSION, dim, f);
    }

    public static LexicalUnit createKiloHertz(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.KILOHERTZ, f);
    }

    public static LexicalUnit createCounter(LexicalUnit prev, LexicalUnit params) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.COUNTER_FUNCTION, "counter", params);
    }

    public static LexicalUnit createCounters(LexicalUnit prev, LexicalUnit params) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.COUNTERS_FUNCTION, "counters", params);
    }

    public static LexicalUnit createAttr(LexicalUnit prev, String value) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.ATTR, "name", value);
    }

    public static LexicalUnit createRect(LexicalUnit prev, LexicalUnit params) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.RECT_FUNCTION, "rect", params);
    }

    public static LexicalUnit createRgbColor(LexicalUnit prev, LexicalUnit params) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.RGBCOLOR, "rgb", params);
    }

    public static LexicalUnit createFunction(LexicalUnit prev, String name, LexicalUnit params) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.FUNCTION, name, params);
    }

    public static LexicalUnit createString(LexicalUnit prev, String value) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.STRING_VALUE, value);
    }

    public static LexicalUnit createIdent(LexicalUnit prev, String value) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.IDENT, value);
    }

    public static LexicalUnit createURI(LexicalUnit prev, String value) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.URI, value);
    }

    public static LexicalUnit createComma(LexicalUnit prev) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.OPERATOR_COMMA);
    }
}

