/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.DownloadedContent;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebResponseData
implements Serializable {
    private static final Log LOG = LogFactory.getLog(WebResponseData.class);
    private final int statusCode_;
    private final String statusMessage_;
    private final List<NameValuePair> responseHeaders_;
    private final DownloadedContent downloadedContent_;

    public WebResponseData(byte[] body, int statusCode, String statusMessage, List<NameValuePair> responseHeaders) {
        this(new DownloadedContent.InMemory(body), statusCode, statusMessage, responseHeaders);
    }

    protected WebResponseData(int statusCode, String statusMessage, List<NameValuePair> responseHeaders) {
        this(ArrayUtils.EMPTY_BYTE_ARRAY, statusCode, statusMessage, responseHeaders);
    }

    public WebResponseData(DownloadedContent downloadedContent, int statusCode, String statusMessage, List<NameValuePair> responseHeaders) {
        this.statusCode_ = statusCode;
        this.statusMessage_ = statusMessage;
        this.responseHeaders_ = Collections.unmodifiableList(responseHeaders);
        this.downloadedContent_ = downloadedContent;
    }

    private InputStream getStream(DownloadedContent downloadedContent, List<NameValuePair> headers) throws IOException {
        InputStream stream = this.downloadedContent_.getInputStream();
        if (downloadedContent.isEmpty()) {
            return stream;
        }
        String encoding = WebResponseData.getHeader(headers, "content-encoding");
        if (encoding != null) {
            if (StringUtils.contains((CharSequence)encoding, "gzip")) {
                try {
                    stream = new GZIPInputStream(stream);
                }
                catch (IOException e) {
                    LOG.error("Reading gzip encodec content failed.", e);
                    stream.close();
                    stream = IOUtils.toInputStream("<html>\n<head><title>Problem loading page</title></head>\n<body>\n<h1>Content Encoding Error</h1>\n<p>The page you are trying to view cannot be shown because it uses an invalid or unsupported form of compression.</p>\n</body>\n</html>", StandardCharsets.ISO_8859_1);
                }
            } else if (StringUtils.contains((CharSequence)encoding, "deflate")) {
                boolean zlibHeader = false;
                if (stream.markSupported()) {
                    stream.mark(2);
                    byte[] buffer = new byte[2];
                    int byteCount = stream.read(buffer, 0, 2);
                    zlibHeader = byteCount == 2 && ((buffer[0] & 0xFF) << 8 | buffer[1] & 0xFF) == 30876;
                    stream.reset();
                }
                stream = zlibHeader ? new InflaterInputStream(stream) : new InflaterInputStream(stream, new Inflater(true));
            }
        }
        return stream;
    }

    private static String getHeader(List<NameValuePair> headers, String name) {
        for (NameValuePair header : headers) {
            String headerName = header.getName().trim();
            if (!name.equalsIgnoreCase(headerName)) continue;
            return header.getValue();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getBody() {
        try (InputStream is = this.getInputStream();){
            byte[] byArray = IOUtils.toByteArray(is);
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream getInputStream() throws IOException {
        return this.getStream(this.downloadedContent_, this.getResponseHeaders());
    }

    public List<NameValuePair> getResponseHeaders() {
        return this.responseHeaders_;
    }

    public int getStatusCode() {
        return this.statusCode_;
    }

    public String getStatusMessage() {
        return this.statusMessage_;
    }

    public long getContentLength() {
        return this.downloadedContent_.length();
    }

    public void cleanUp() {
        this.downloadedContent_.cleanUp();
    }
}

