/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.host.Iterator;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import java.util.Map;
import java.util.WeakHashMap;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Delegator;
import net.sourceforge.htmlunit.corejs.javascript.NativeArray;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass
public class WeakMap
extends SimpleScriptable {
    private transient Map<Object, Object> map_ = new WeakHashMap<Object, Object>();

    public WeakMap() {
    }

    @JsxConstructor
    public WeakMap(Object arrayLike) {
        if (arrayLike == Undefined.instance) {
            return;
        }
        Context context = Context.getCurrentContext();
        Window window = (Window)ScriptRuntime.getTopCallScope(context);
        if (window.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_WEAKMAP_CONSTRUCTOR_IGNORE_ARGUMENT)) {
            return;
        }
        if (arrayLike instanceof NativeArray) {
            NativeArray array = (NativeArray)arrayLike;
            int i = 0;
            while ((long)i < array.getLength()) {
                Object entryObject = array.get(i);
                if (entryObject instanceof NativeArray) {
                    Object key;
                    Object[] entry = WeakMap.toArray((NativeArray)entryObject);
                    if (entry.length > 0 && Undefined.instance != (key = entry[0]) && key instanceof ScriptableObject) {
                        Object value2 = entry.length > 1 ? entry[1] : null;
                        this.set(key, value2);
                    }
                } else {
                    throw Context.reportRuntimeError("TypeError: object is not iterable (" + entryObject.getClass().getName() + ")");
                }
                ++i;
            }
            return;
        }
        if (arrayLike instanceof Scriptable) {
            Scriptable scriptable = (Scriptable)arrayLike;
            if (Iterator.iterate(Context.getCurrentContext(), this, scriptable, value -> {
                if (Undefined.instance != value && value instanceof NativeArray) {
                    Object key;
                    Object[] entry = WeakMap.toArray((NativeArray)value);
                    if (entry.length > 0 && Undefined.instance != (key = entry[0]) && key instanceof ScriptableObject) {
                        Object entryValue = entry.length > 1 ? entry[1] : null;
                        this.set(key, entryValue);
                    }
                } else {
                    throw Context.reportRuntimeError("TypeError: object is not iterable (" + value.getClass().getName() + ")");
                }
            })) {
                return;
            }
        }
        throw Context.reportRuntimeError("TypeError: object is not iterable (" + arrayLike.getClass().getName() + ")");
    }

    private static Object[] toArray(NativeArray narray) {
        long longLen = narray.getLength();
        if (longLen > Integer.MAX_VALUE) {
            throw new IllegalStateException();
        }
        int len = (int)longLen;
        Object[] arr = new Object[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = ScriptableObject.getProperty((Scriptable)narray, i);
        }
        return arr;
    }

    @Override
    @JsxFunction
    public Object get(Object key) {
        Object o = this.map_.get(key);
        if (o == null) {
            o = Undefined.instance;
        }
        return o;
    }

    @JsxFunction
    public WeakMap set(Object key, Object value) {
        if (key instanceof Delegator) {
            key = ((Delegator)key).getDelegee();
        }
        if (!(key instanceof ScriptableObject)) {
            throw Context.reportRuntimeError("TypeError: key is not an object");
        }
        this.map_.put(key, value);
        return this;
    }

    @JsxFunction
    public void clear() {
        this.map_.clear();
    }

    @JsxFunction
    public boolean delete(Object key) {
        return this.map_.remove(key) != null;
    }

    @JsxFunction
    public boolean has(Object key) {
        return this.map_.remove(key) != null;
    }
}

