/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.regexp;

import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

public class RegExpJsToJavaConverter {
    private static final String DIGITS = "0123456789";
    private Tape tape_;
    private boolean insideCharClass_;
    private boolean insideRepetition_;
    private Stack<Subexpresion> parsingSubexpressions_;
    private List<Subexpresion> subexpressions_;

    public String convert(String input) {
        this.tape_ = new Tape(input);
        this.insideCharClass_ = false;
        this.insideRepetition_ = false;
        this.parsingSubexpressions_ = new Stack();
        this.subexpressions_ = new LinkedList<Subexpresion>();
        int current = this.tape_.read();
        while (current > -1) {
            if (92 == current) {
                this.processEscapeSequence();
            } else if (91 == current) {
                this.processCharClassStart();
            } else if (93 == current) {
                this.processCharClassEnd();
            } else if (123 == current) {
                this.processRepetitionStart();
            } else if (125 == current) {
                this.processRepetitionEnd();
            } else if (40 == current) {
                this.processSubExpressionStart();
            } else if (41 == current) {
                this.processSubExpressionEnd();
            }
            current = this.tape_.read();
        }
        return this.tape_.toString();
    }

    private void processCharClassStart() {
        if (this.insideCharClass_) {
            this.tape_.insert("\\", -1);
        } else {
            this.insideCharClass_ = true;
            int next = this.tape_.read();
            if (next < 0) {
                this.tape_.insert("\\", -1);
                return;
            }
            if (94 == next) {
                next = this.tape_.read();
                if (next < 0) {
                    this.tape_.insert("\\", -2);
                    return;
                }
                if (92 == next) {
                    next = this.tape_.read();
                    if (DIGITS.indexOf(next) < 0) {
                        this.tape_.move(-2);
                        return;
                    }
                    if (this.handleBackReferenceOrOctal(next) && 93 == (next = this.tape_.read())) {
                        this.tape_.move(-3);
                        this.tape_.replace(3, ".");
                        this.insideCharClass_ = false;
                    }
                } else if (93 == next) {
                    this.tape_.move(-3);
                    this.tape_.replace(3, ".");
                } else {
                    this.tape_.move(-1);
                }
            } else if (93 == next) {
                this.tape_.move(-2);
                this.tape_.replace(2, "(?!)");
            } else {
                this.tape_.move(-1);
            }
        }
    }

    private void processCharClassEnd() {
        this.insideCharClass_ = false;
    }

    private void processRepetitionStart() {
        int next = this.tape_.read();
        if (next < 0) {
            this.tape_.insert("\\", -1);
            return;
        }
        if (DIGITS.indexOf(next) > -1) {
            this.insideRepetition_ = true;
        } else {
            this.tape_.insert("\\", -2);
            this.tape_.move(-1);
        }
    }

    private void processRepetitionEnd() {
        if (this.insideRepetition_) {
            this.insideRepetition_ = false;
            return;
        }
        this.tape_.insert("\\", -1);
    }

    private void processSubExpressionStart() {
        int next = this.tape_.read();
        if (next < 0) {
            return;
        }
        if (63 != next) {
            Subexpresion sub = new Subexpresion();
            sub.start_ = this.tape_.currentPos_;
            this.parsingSubexpressions_.push(sub);
            this.subexpressions_.add(sub);
            this.tape_.move(-1);
            return;
        }
        next = this.tape_.read();
        if (next < 0) {
            return;
        }
        if (58 != next) {
            Subexpresion sub = new Subexpresion();
            sub.start_ = this.tape_.currentPos_;
            this.parsingSubexpressions_.push(sub);
            this.subexpressions_.add(sub);
            this.tape_.move(-1);
            return;
        }
        Subexpresion sub = new Subexpresion();
        sub.start_ = this.tape_.currentPos_;
        this.parsingSubexpressions_.push(sub);
    }

    private void processSubExpressionEnd() {
        if (this.parsingSubexpressions_.isEmpty()) {
            return;
        }
        Subexpresion sub = this.parsingSubexpressions_.pop();
        sub.closed_ = true;
        sub.end_ = this.tape_.currentPos_;
        int next = this.tape_.read();
        sub.optional_ = 63 == next;
        this.tape_.move(-1);
    }

    private void processEscapeSequence() {
        int escapeSequence = this.tape_.read();
        if (escapeSequence < 0) {
            return;
        }
        if (120 == escapeSequence) {
            this.tape_.move(2);
            return;
        }
        if (117 == escapeSequence) {
            this.tape_.move(4);
            return;
        }
        if ("ACEFGHIJKLMNOPQRTUVXYZaeghijklmpqyz".indexOf(escapeSequence) > -1) {
            this.tape_.move(-2);
            this.tape_.remove(1);
            this.tape_.move(1);
            return;
        }
        if (this.insideCharClass_ && 98 == escapeSequence) {
            this.tape_.move(-1);
            this.tape_.replace(1, "cH");
            return;
        }
        if (DIGITS.indexOf(escapeSequence) > -1) {
            this.handleBackReferenceOrOctal(escapeSequence);
        }
    }

    private boolean handleBackReferenceOrOctal(int aFirstChar) {
        Subexpresion back;
        StringBuilder tmpNo = new StringBuilder(Character.toString((char)aFirstChar));
        int tmpInsertPos = -1;
        int next = this.tape_.read();
        if (next > -1) {
            if (DIGITS.indexOf(next) > -1) {
                tmpNo.append(next);
                --tmpInsertPos;
                next = this.tape_.read();
                if (next > -1) {
                    if (DIGITS.indexOf(next) > -1) {
                        tmpNo.append(next);
                        --tmpInsertPos;
                    } else {
                        this.tape_.move(-1);
                    }
                }
            } else {
                this.tape_.move(-1);
                if (48 == aFirstChar) {
                    this.tape_.insert("x0", -1);
                    return false;
                }
            }
        } else if (48 == aFirstChar) {
            this.tape_.insert("x0", -1);
            return false;
        }
        if (tmpNo.charAt(0) == '0') {
            return false;
        }
        int value = Integer.parseInt(tmpNo.toString());
        if (value > this.subexpressions_.size()) {
            this.tape_.insert("0", tmpInsertPos);
            return false;
        }
        if (this.insideCharClass_ || 0 < value && value <= this.subexpressions_.size() && !this.subexpressions_.get(value - 1).closed_ || value > this.subexpressions_.size()) {
            for (int i = tmpInsertPos; i <= 0; ++i) {
                this.tape_.move(-1);
                this.tape_.remove(1);
            }
        }
        if ((back = this.subexpressions_.get(value - 1)).optional_ && !back.enhanced_) {
            int insertPos = back.start_ - 1;
            this.tape_.insertAt("(?:", insertPos);
            for (Subexpresion subexp : this.subexpressions_) {
                if (subexp.start_ > insertPos) {
                    subexp.start_ = subexp.start_ + 3;
                }
                if (subexp.end_ <= insertPos) continue;
                subexp.end_ = subexp.end_ + 3;
            }
            insertPos = back.end_ + 1;
            this.tape_.insertAt(")", insertPos);
            for (Subexpresion subexp : this.subexpressions_) {
                if (subexp.start_ > insertPos) {
                    subexp.start_ = subexp.start_ + 1;
                }
                if (subexp.end_ <= insertPos) continue;
                subexp.end_ = subexp.end_ + 1;
            }
        }
        return true;
    }

    private static final class Subexpresion {
        private boolean closed_ = false;
        private boolean optional_ = false;
        private boolean enhanced_ = false;
        private int start_ = -1;
        private int end_ = -1;

        private Subexpresion() {
        }
    }

    private static class Tape {
        private final StringBuilder tape_;
        private int currentPos_ = 0;

        Tape(String input) {
            this.tape_ = new StringBuilder(input);
        }

        public void move(int offset) {
            this.currentPos_ += offset;
        }

        public int read() {
            if (this.currentPos_ < 0) {
                return -1;
            }
            if (this.currentPos_ >= this.tape_.length()) {
                return -1;
            }
            return this.tape_.charAt(this.currentPos_++);
        }

        public void insert(String token, int offset) {
            this.tape_.insert(this.currentPos_ + offset, token);
            this.currentPos_ += token.length();
        }

        public void insertAt(String token, int pos) {
            this.tape_.insert(pos, token);
            this.currentPos_ += token.length();
        }

        public void replace(int count, String token) {
            this.tape_.replace(this.currentPos_, this.currentPos_ + count, token);
            this.currentPos_ += token.length();
        }

        public void remove(int count) {
            this.tape_.delete(this.currentPos_, this.currentPos_ + count);
        }

        public String toString() {
            return this.tape_.toString();
        }
    }
}

