/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web.servlet;

import com.google.common.collect.Lists;
import com.google.common.io.CharStreams;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openqa.grid.common.RegistrationRequest;
import org.openqa.grid.common.exception.GridConfigurationException;
import org.openqa.grid.internal.BaseRemoteProxy;
import org.openqa.grid.internal.GridRegistry;
import org.openqa.grid.internal.RemoteProxy;
import org.openqa.grid.internal.utils.configuration.GridNodeConfiguration;
import org.openqa.grid.web.servlet.RegistryBasedServlet;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.json.Json;

public class RegistrationServlet
extends RegistryBasedServlet {
    private static final long serialVersionUID = -8670670577712086527L;
    private static final Logger log = Logger.getLogger(RegistrationServlet.class.getName());
    private static final Json JSON = new Json();

    public RegistrationServlet() {
        this(null);
    }

    public RegistrationServlet(GridRegistry registry) {
        super(registry);
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.process(request, response);
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.process(request, response);
    }

    protected void process(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RegistrationRequest registrationRequest;
        String requestJsonString;
        try (BufferedReader rd = new BufferedReader(new InputStreamReader(request.getInputStream()));){
            requestJsonString = CharStreams.toString(rd);
        }
        log.fine("getting the following registration request  : " + requestJsonString);
        Map json = (Map)JSON.toType(requestJsonString, Json.MAP_TYPE);
        if (!(json.get("configuration") instanceof Map)) {
            throw new GridConfigurationException("No configuration received for proxy.");
        }
        if (this.isV2RegistrationRequestJson(json)) {
            GridNodeConfiguration nodeConfiguration = this.mapV2Configuration((Map)json.get("configuration"));
            registrationRequest = new RegistrationRequest(nodeConfiguration);
            this.considerV2Json(registrationRequest.getConfiguration(), json);
        } else {
            registrationRequest = RegistrationRequest.fromJson(requestJsonString);
        }
        Object proxy = BaseRemoteProxy.getNewInstance(registrationRequest, this.getRegistry());
        this.reply(response, "ok");
        new Thread(() -> {
            this.getRegistry().add((RemoteProxy)proxy);
            log.fine("proxy added " + proxy.getRemoteHost());
        }).start();
    }

    @Deprecated
    private GridNodeConfiguration mapV2Configuration(Map<String, Object> json) {
        Object servlets = json.get("servlets");
        if (servlets instanceof String) {
            json.remove("servlets");
        }
        GridNodeConfiguration pendingConfiguration = GridNodeConfiguration.loadFromJSON(JSON.toJson(json));
        if (servlets instanceof String && (pendingConfiguration.servlets == null || pendingConfiguration.servlets.isEmpty())) {
            pendingConfiguration.servlets = Lists.newArrayList(servlets.toString().split(","));
        }
        return pendingConfiguration;
    }

    @Deprecated
    private boolean isV2RegistrationRequestJson(Map<String, Object> json) {
        return json.containsKey("capabilities") && json.containsKey("configuration");
    }

    @Deprecated
    private void considerV2Json(GridNodeConfiguration configuration, Map<String, Object> json) {
        if (json.get("id") instanceof String) {
            configuration.id = json.get("id").toString();
        }
        if (json.get("capabilities") instanceof Collection) {
            configuration.capabilities.clear();
            Collection capabilities = (Collection)json.get("capabilities");
            capabilities.stream().map(MutableCapabilities::new).forEach(configuration.capabilities::add);
            configuration.fixUpCapabilities();
        }
    }

    protected void reply(HttpServletResponse response, String content) throws IOException {
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        response.setStatus(200);
        response.getWriter().print(content);
    }
}

