/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.logging.Level;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.UnexpectedAlertBehaviour;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxDriverLogLevel;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.ProfilesIni;

public class FirefoxOptions
extends MutableCapabilities {
    public static final String FIREFOX_OPTIONS = "moz:firefoxOptions";
    private List<String> args = new ArrayList<String>();
    private Map<String, Boolean> booleanPrefs = new TreeMap<String, Boolean>();
    private Map<String, Integer> intPrefs = new TreeMap<String, Integer>();
    private Map<String, String> stringPrefs = new TreeMap<String, String>();
    private FirefoxDriverLogLevel logLevel;
    private Binary binary;
    private boolean legacy;
    private FirefoxProfile profile;

    public FirefoxOptions() {
        String forceMarionette;
        String profileName;
        String binary = System.getProperty("webdriver.firefox.bin");
        if (binary != null) {
            this.setBinary(binary);
        }
        if ((profileName = System.getProperty("webdriver.firefox.profile")) != null) {
            FirefoxProfile profile = new ProfilesIni().getProfile(profileName);
            if (profile == null) {
                throw new WebDriverException(String.format("Firefox profile '%s' named in system property '%s' not found", profileName, "webdriver.firefox.profile"));
            }
            this.setProfile(profile);
        }
        if ((forceMarionette = System.getProperty("webdriver.firefox.marionette")) != null) {
            this.setLegacy(!Boolean.getBoolean("webdriver.firefox.marionette"));
        }
        this.setCapability("browserName", "firefox");
        this.setAcceptInsecureCerts(true);
    }

    public FirefoxOptions(Capabilities source) {
        source.asMap().forEach((key, value) -> {
            if (value != null) {
                this.setCapability((String)key, value);
            }
        });
        Object raw = source.getCapability(FIREFOX_OPTIONS);
        if (raw == null) {
            return;
        }
        if (raw instanceof FirefoxOptions) {
            FirefoxOptions that = (FirefoxOptions)raw;
            this.addArguments(that.args);
            that.booleanPrefs.forEach(this::addPreference);
            that.intPrefs.forEach(this::addPreference);
            that.stringPrefs.forEach(this::addPreference);
            this.setLegacy(that.legacy);
            if (that.logLevel != null) {
                this.setLogLevel(that.logLevel);
            }
            if (that.binary != null) {
                this.setCapability("firefox_binary", that.binary.asCapability());
            }
            if (that.profile != null) {
                this.setProfile(that.profile);
            }
        } else if (raw instanceof Map) {
            Object value2;
            Map that = (Map)raw;
            if (that.containsKey("args")) {
                value2 = that.get("args");
                if (value2 instanceof String) {
                    this.addArguments((String)that.get("args"));
                } else if (value2 instanceof List) {
                    this.addArguments((List)that.get("args"));
                } else {
                    this.addArguments(that.get("args").toString());
                }
            }
            if (that.containsKey("prefs")) {
                Map prefs = (Map)that.get("prefs");
                prefs.forEach((k, v) -> {
                    if (v instanceof String) {
                        this.stringPrefs.put((String)k, (String)v);
                    } else if (v instanceof Number) {
                        this.intPrefs.put((String)k, ((Number)v).intValue());
                    } else if (v instanceof Boolean) {
                        this.booleanPrefs.put((String)k, (Boolean)v);
                    }
                });
            }
            if (that.containsKey("binary")) {
                this.setBinary((String)that.get("binary"));
            }
            if (that.containsKey("log")) {
                Map logStruct = (Map)that.get("log");
                Object rawLevel = logStruct.get("level");
                if (rawLevel instanceof String) {
                    this.setLogLevel(FirefoxDriverLogLevel.fromString((String)rawLevel));
                } else if (rawLevel instanceof FirefoxDriverLogLevel) {
                    this.setLogLevel((FirefoxDriverLogLevel)((Object)rawLevel));
                }
            }
            if (that.containsKey("profile")) {
                value2 = that.get("profile");
                if (value2 instanceof String) {
                    try {
                        this.setProfile(FirefoxProfile.fromJson((String)value2));
                    }
                    catch (IOException e) {
                        throw new WebDriverException(e);
                    }
                } else if (value2 instanceof FirefoxProfile) {
                    this.setProfile((FirefoxProfile)value2);
                } else {
                    throw new WebDriverException("In FirefoxOptions, don't know how to convert profile: " + that);
                }
            }
        }
    }

    public FirefoxOptions setLegacy(boolean legacy) {
        this.setCapability("marionette", !legacy);
        return this;
    }

    public boolean isLegacy() {
        return this.legacy;
    }

    public FirefoxOptions setBinary(FirefoxBinary binary) {
        this.setCapability("firefox_binary", binary);
        return this;
    }

    public FirefoxOptions setBinary(Path path) {
        this.setCapability("firefox_binary", path);
        return this;
    }

    public FirefoxOptions setBinary(String path) {
        this.setCapability("firefox_binary", path);
        return this;
    }

    public FirefoxBinary getBinary() {
        return this.getBinaryOrNull().orElseGet(FirefoxBinary::new);
    }

    public Optional<FirefoxBinary> getBinaryOrNull() {
        return Optional.ofNullable(this.binary).map(Binary::asBinary);
    }

    public FirefoxOptions setProfile(FirefoxProfile profile) {
        this.setCapability("firefox_profile", profile);
        return this;
    }

    public FirefoxProfile getProfile() {
        return this.profile;
    }

    public FirefoxOptions addArguments(String ... arguments) {
        this.addArguments(ImmutableList.copyOf(arguments));
        return this;
    }

    public FirefoxOptions addArguments(List<String> arguments) {
        this.args.addAll(arguments);
        return this;
    }

    public FirefoxOptions addPreference(String key, boolean value) {
        this.booleanPrefs.put(Objects.requireNonNull(key), value);
        return this;
    }

    public FirefoxOptions addPreference(String key, int value) {
        this.intPrefs.put(Objects.requireNonNull(key), value);
        return this;
    }

    public FirefoxOptions addPreference(String key, String value) {
        this.stringPrefs.put(Objects.requireNonNull(key), value);
        return this;
    }

    @Deprecated
    public FirefoxOptions setLogLevel(Level logLevel) {
        this.setLogLevel(FirefoxDriverLogLevel.fromLevel(logLevel));
        return this;
    }

    public FirefoxOptions setLogLevel(FirefoxDriverLogLevel logLevel) {
        this.logLevel = Objects.requireNonNull(logLevel, "Log level must be set");
        return this;
    }

    public FirefoxOptions setPageLoadStrategy(PageLoadStrategy strategy) {
        this.setCapability("pageLoadStrategy", (Object)Objects.requireNonNull(strategy, "Page load strategy must be set"));
        return this;
    }

    public FirefoxOptions setUnhandledPromptBehaviour(UnexpectedAlertBehaviour behaviour) {
        this.setCapability("unhandledPromptBehavior", (Object)Objects.requireNonNull(behaviour, "Unhandled prompt behavior must be set"));
        return this;
    }

    public FirefoxOptions setAcceptInsecureCerts(boolean acceptInsecureCerts) {
        this.setCapability("acceptInsecureCerts", acceptInsecureCerts);
        return this;
    }

    public FirefoxOptions setHeadless(boolean headless) {
        this.args.remove("-headless");
        if (headless) {
            this.args.add("-headless");
        }
        return this;
    }

    public FirefoxOptions setProxy(Proxy proxy) {
        this.setCapability("proxy", proxy);
        return this;
    }

    @Override
    public void setCapability(String key, Object value) {
        switch (key) {
            case "firefox_binary": {
                this.binary = new Binary(Objects.requireNonNull(value, "Binary value cannot be null"));
                value = this.binary.asCapability();
                break;
            }
            case "marionette": {
                if (!(value instanceof Boolean)) break;
                this.legacy = (Boolean)value == false;
                break;
            }
            case "firefox_profile": {
                if (value instanceof FirefoxProfile) {
                    this.profile = (FirefoxProfile)value;
                    break;
                }
                if (value instanceof String) {
                    try {
                        this.profile = FirefoxProfile.fromJson((String)value);
                    }
                    catch (IOException e) {
                        throw new WebDriverException(e);
                    }
                    value = this.profile;
                    break;
                }
                throw new WebDriverException("Unexpected value for profile: " + value);
            }
        }
        super.setCapability(key, value);
    }

    @Override
    public Map<String, Object> asMap() {
        TreeMap<String, Object> toReturn = new TreeMap<String, Object>();
        toReturn.putAll(super.asMap());
        ImmutableSortedMap.Builder w3cOptions = ImmutableSortedMap.naturalOrder();
        w3cOptions.put("args", this.args);
        if (this.binary != null) {
            w3cOptions.put("binary", this.binary.asPath());
        }
        if (this.logLevel != null) {
            w3cOptions.put("log", ImmutableMap.of("level", this.logLevel));
        }
        if (this.profile != null) {
            for (Map.Entry<String, Boolean> entry : this.booleanPrefs.entrySet()) {
                this.profile.setPreference(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Comparable<Boolean>> entry : this.intPrefs.entrySet()) {
                this.profile.setPreference(entry.getKey(), (Integer)entry.getValue());
            }
            for (Map.Entry<String, Object> entry : this.stringPrefs.entrySet()) {
                this.profile.setPreference(entry.getKey(), (String)entry.getValue());
            }
            try {
                w3cOptions.put("profile", this.profile.toJson());
            }
            catch (IOException e) {
                throw new WebDriverException(e);
            }
        } else {
            ImmutableMap.Builder<String, Object> allPrefs = ImmutableMap.builder();
            allPrefs.putAll(this.booleanPrefs);
            allPrefs.putAll(this.intPrefs);
            allPrefs.putAll(this.stringPrefs);
            w3cOptions.put("prefs", allPrefs.build());
        }
        toReturn.put(FIREFOX_OPTIONS, w3cOptions.build());
        return toReturn;
    }

    @Override
    public FirefoxOptions merge(Capabilities capabilities) {
        super.merge(capabilities);
        return this;
    }

    @Override
    protected int amendHashCode() {
        return Objects.hash(new Object[]{this.args, this.booleanPrefs, this.intPrefs, this.stringPrefs, this.logLevel, this.binary, this.legacy, this.profile});
    }

    private class Binary {
        private String path;
        private FirefoxBinary binary;

        public Binary(Object value) {
            if (value instanceof FirefoxBinary) {
                this.binary = (FirefoxBinary)value;
                this.binary.amendOptions(FirefoxOptions.this);
                return;
            }
            if (value instanceof Path || value instanceof String) {
                this.path = value.toString().replace('\\', '/');
                return;
            }
            throw new IllegalArgumentException("Unrecognised type for binary: " + value);
        }

        FirefoxBinary asBinary() {
            return this.binary == null ? new FirefoxBinary(new File(this.path)) : this.binary;
        }

        Object asCapability() {
            return this.binary == null ? this.path : this.binary;
        }

        String asPath() {
            return this.binary == null ? this.path : this.binary.getPath();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Binary)) {
                return false;
            }
            Binary that = (Binary)o;
            return Objects.equals(this.path, that.path) && Objects.equals(this.binary, that.binary);
        }

        public int hashCode() {
            return Objects.hash(this.path, this.binary);
        }
    }
}

