/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox.internal;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.FirefoxBinary;

@Deprecated
public class Executable {
    private final File binary;
    private String version;
    private FirefoxBinary.Channel channel;

    public Executable(File userSpecifiedBinaryPath) {
        Preconditions.checkState(userSpecifiedBinaryPath != null, "Path to the firefox binary should not be null");
        Preconditions.checkState(userSpecifiedBinaryPath.exists() && userSpecifiedBinaryPath.isFile(), "Specified firefox binary location does not exist or is not a real file: " + userSpecifiedBinaryPath);
        this.binary = userSpecifiedBinaryPath;
    }

    public File getDirectory() {
        return this.binary.getAbsoluteFile().getParentFile();
    }

    public File getFile() {
        return this.binary;
    }

    public String getPath() {
        return this.binary.getAbsolutePath();
    }

    public String getVersion() {
        if (this.version == null) {
            this.loadApplicationIni();
        }
        return this.version;
    }

    public FirefoxBinary.Channel getChannel() {
        if (this.channel == null) {
            this.loadChannelPref();
        }
        return this.channel;
    }

    private void loadApplicationIni() {
        Optional<Path> applicationIni = this.getResource("application.ini");
        if (applicationIni.isPresent()) {
            try (BufferedReader reader = Files.newBufferedReader(applicationIni.get());){
                reader.lines().map(String::trim).forEach(line -> {
                    if (line.startsWith("Version=")) {
                        this.version = line.substring("Version=".length());
                    }
                });
            }
            catch (IOException e) {
                throw new WebDriverException("Cannot get version info for of Firefox binary " + this.binary, e);
            }
            return;
        }
        this.version = "1000.0 unknown";
    }

    private void loadChannelPref() {
        Optional<Path> channelPrefs = this.getResource("defaults/pref/channel-prefs.js");
        if (channelPrefs.isPresent()) {
            try (BufferedReader reader = Files.newBufferedReader(channelPrefs.get());){
                reader.lines().map(String::trim).forEach(line -> {
                    if (line.startsWith("pref(")) {
                        this.channel = FirefoxBinary.Channel.fromString(line.substring("pref(\"app.update.channel\", \"".length(), line.length() - "\");".length()));
                    }
                });
            }
            catch (IOException e) {
                throw new WebDriverException("Cannot get channel info for Firefox binary " + this.binary, e);
            }
            return;
        }
        this.channel = FirefoxBinary.Channel.RELEASE;
    }

    private Optional<Path> getResource(String resourceName) {
        Path binaryLocation = this.binary.getAbsoluteFile().toPath();
        Path discovered = Platform.getCurrent().is(Platform.MAC) ? binaryLocation.getParent().getParent().resolve("Resources").resolve(resourceName) : binaryLocation.getParent().resolve(resourceName);
        if (Files.exists(discovered, new LinkOption[0])) {
            return Optional.of(discovered);
        }
        return Optional.empty();
    }
}

