/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support.events;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.openqa.selenium.Alert;
import org.openqa.selenium.Beta;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsDriver;
import org.openqa.selenium.WrapsElement;
import org.openqa.selenium.interactions.HasInputDevices;
import org.openqa.selenium.interactions.HasTouchScreen;
import org.openqa.selenium.interactions.Interactive;
import org.openqa.selenium.interactions.Keyboard;
import org.openqa.selenium.interactions.Mouse;
import org.openqa.selenium.interactions.Sequence;
import org.openqa.selenium.interactions.TouchScreen;
import org.openqa.selenium.interactions.internal.Coordinates;
import org.openqa.selenium.interactions.internal.Locatable;
import org.openqa.selenium.logging.Logs;
import org.openqa.selenium.support.events.WebDriverEventListener;
import org.openqa.selenium.support.events.internal.EventFiringKeyboard;
import org.openqa.selenium.support.events.internal.EventFiringMouse;
import org.openqa.selenium.support.events.internal.EventFiringTouch;

public class EventFiringWebDriver
implements WebDriver,
JavascriptExecutor,
TakesScreenshot,
WrapsDriver,
HasInputDevices,
HasTouchScreen,
Interactive,
HasCapabilities {
    private final WebDriver driver;
    private final List<WebDriverEventListener> eventListeners = new ArrayList<WebDriverEventListener>();
    private final WebDriverEventListener dispatcher = (WebDriverEventListener)Proxy.newProxyInstance(WebDriverEventListener.class.getClassLoader(), new Class[]{WebDriverEventListener.class}, (proxy, method, args) -> {
        try {
            for (WebDriverEventListener eventListener : this.eventListeners) {
                method.invoke((Object)eventListener, args);
            }
            return null;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    });

    public EventFiringWebDriver(WebDriver driver) {
        Class<?>[] allInterfaces = this.extractInterfaces(driver);
        this.driver = (WebDriver)Proxy.newProxyInstance(WebDriverEventListener.class.getClassLoader(), allInterfaces, (proxy, method, args) -> {
            if ("getWrappedDriver".equals(method.getName())) {
                return driver;
            }
            try {
                return method.invoke((Object)driver, args);
            }
            catch (InvocationTargetException e) {
                this.dispatcher.onException(e.getTargetException(), driver);
                throw e.getTargetException();
            }
        });
    }

    private Class<?>[] extractInterfaces(Object object) {
        HashSet allInterfaces = new HashSet();
        allInterfaces.add(WrapsDriver.class);
        if (object instanceof WebElement) {
            allInterfaces.add(WrapsElement.class);
        }
        this.extractInterfaces(allInterfaces, object.getClass());
        return allInterfaces.toArray(new Class[allInterfaces.size()]);
    }

    private void extractInterfaces(Set<Class<?>> addTo, Class<?> clazz) {
        if (Object.class.equals(clazz)) {
            return;
        }
        Class<?>[] classes = clazz.getInterfaces();
        addTo.addAll(Arrays.asList(classes));
        this.extractInterfaces(addTo, clazz.getSuperclass());
    }

    public EventFiringWebDriver register(WebDriverEventListener eventListener) {
        this.eventListeners.add(eventListener);
        return this;
    }

    public EventFiringWebDriver unregister(WebDriverEventListener eventListener) {
        this.eventListeners.remove(eventListener);
        return this;
    }

    @Override
    public WebDriver getWrappedDriver() {
        if (this.driver instanceof WrapsDriver) {
            return ((WrapsDriver)((Object)this.driver)).getWrappedDriver();
        }
        return this.driver;
    }

    @Override
    public void get(String url) {
        this.dispatcher.beforeNavigateTo(url, this.driver);
        this.driver.get(url);
        this.dispatcher.afterNavigateTo(url, this.driver);
    }

    @Override
    public String getCurrentUrl() {
        return this.driver.getCurrentUrl();
    }

    @Override
    public String getTitle() {
        return this.driver.getTitle();
    }

    @Override
    public List<WebElement> findElements(By by) {
        this.dispatcher.beforeFindBy(by, null, this.driver);
        List<WebElement> temp = this.driver.findElements(by);
        this.dispatcher.afterFindBy(by, null, this.driver);
        ArrayList<WebElement> result = new ArrayList<WebElement>(temp.size());
        for (WebElement element : temp) {
            result.add(this.createWebElement(element));
        }
        return result;
    }

    @Override
    public WebElement findElement(By by) {
        this.dispatcher.beforeFindBy(by, null, this.driver);
        WebElement temp = this.driver.findElement(by);
        this.dispatcher.afterFindBy(by, temp, this.driver);
        return this.createWebElement(temp);
    }

    @Override
    public String getPageSource() {
        return this.driver.getPageSource();
    }

    @Override
    public void close() {
        this.driver.close();
    }

    @Override
    public void quit() {
        this.driver.quit();
    }

    @Override
    public Set<String> getWindowHandles() {
        return this.driver.getWindowHandles();
    }

    @Override
    public String getWindowHandle() {
        return this.driver.getWindowHandle();
    }

    @Override
    public Object executeScript(String script, Object ... args) {
        if (this.driver instanceof JavascriptExecutor) {
            this.dispatcher.beforeScript(script, this.driver);
            Object[] usedArgs = this.unpackWrappedArgs(args);
            Object result = ((JavascriptExecutor)((Object)this.driver)).executeScript(script, usedArgs);
            this.dispatcher.afterScript(script, this.driver);
            return this.wrapResult(result);
        }
        throw new UnsupportedOperationException("Underlying driver instance does not support executing javascript");
    }

    @Override
    public Object executeAsyncScript(String script, Object ... args) {
        if (this.driver instanceof JavascriptExecutor) {
            this.dispatcher.beforeScript(script, this.driver);
            Object[] usedArgs = this.unpackWrappedArgs(args);
            Object result = ((JavascriptExecutor)((Object)this.driver)).executeAsyncScript(script, usedArgs);
            this.dispatcher.afterScript(script, this.driver);
            return result;
        }
        throw new UnsupportedOperationException("Underlying driver instance does not support executing javascript");
    }

    private Object[] unpackWrappedArgs(Object ... args) {
        Object[] usedArgs = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            usedArgs[i] = this.unpackWrappedElement(args[i]);
        }
        return usedArgs;
    }

    private Object unpackWrappedElement(Object arg) {
        if (arg instanceof List) {
            List aList = (List)arg;
            ArrayList<Object> toReturn = new ArrayList<Object>();
            for (Object anAList : aList) {
                toReturn.add(this.unpackWrappedElement(anAList));
            }
            return toReturn;
        }
        if (arg instanceof Map) {
            Map aMap = (Map)arg;
            HashMap toReturn = new HashMap();
            for (Object key : aMap.keySet()) {
                toReturn.put(key, this.unpackWrappedElement(aMap.get(key)));
            }
            return toReturn;
        }
        if (arg instanceof EventFiringWebElement) {
            return ((EventFiringWebElement)arg).getWrappedElement();
        }
        return arg;
    }

    private Object wrapResult(Object result) {
        if (result instanceof WebElement) {
            return new EventFiringWebElement((WebElement)result);
        }
        if (result instanceof List) {
            return ((List)result).stream().map(this::wrapResult).collect(Collectors.toList());
        }
        if (result instanceof Map) {
            return ((Map)result).entrySet().stream().collect(HashMap::new, (m, e) -> m.put(e.getKey(), e.getValue()), Map::putAll);
        }
        return result;
    }

    @Override
    public <X> X getScreenshotAs(OutputType<X> target) throws WebDriverException {
        if (this.driver instanceof TakesScreenshot) {
            this.dispatcher.beforeGetScreenshotAs(target);
            X screenshot = ((TakesScreenshot)((Object)this.driver)).getScreenshotAs(target);
            this.dispatcher.afterGetScreenshotAs(target, screenshot);
            return screenshot;
        }
        throw new UnsupportedOperationException("Underlying driver instance does not support taking screenshots");
    }

    @Override
    public WebDriver.TargetLocator switchTo() {
        return new EventFiringTargetLocator(this.driver.switchTo());
    }

    @Override
    public WebDriver.Navigation navigate() {
        return new EventFiringNavigation(this.driver.navigate());
    }

    @Override
    public WebDriver.Options manage() {
        return new EventFiringOptions(this.driver.manage());
    }

    private WebElement createWebElement(WebElement from) {
        return new EventFiringWebElement(from);
    }

    @Override
    public Keyboard getKeyboard() {
        if (this.driver instanceof HasInputDevices) {
            return new EventFiringKeyboard(this.driver, this.dispatcher);
        }
        throw new UnsupportedOperationException("Underlying driver does not implement advanced user interactions yet.");
    }

    @Override
    public Mouse getMouse() {
        if (this.driver instanceof HasInputDevices) {
            return new EventFiringMouse(this.driver, this.dispatcher);
        }
        throw new UnsupportedOperationException("Underlying driver does not implement advanced user interactions yet.");
    }

    @Override
    public TouchScreen getTouch() {
        if (this.driver instanceof HasTouchScreen) {
            return new EventFiringTouch(this.driver, this.dispatcher);
        }
        throw new UnsupportedOperationException("Underlying driver does not implement advanced user interactions yet.");
    }

    @Override
    public void perform(Collection<Sequence> actions2) {
        if (this.driver instanceof Interactive) {
            ((Interactive)((Object)this.driver)).perform(actions2);
            return;
        }
        throw new UnsupportedOperationException("Underlying driver does not implement advanced user interactions yet.");
    }

    @Override
    public void resetInputState() {
        if (this.driver instanceof Interactive) {
            ((Interactive)((Object)this.driver)).resetInputState();
            return;
        }
        throw new UnsupportedOperationException("Underlying driver does not implement advanced user interactions yet.");
    }

    @Override
    public Capabilities getCapabilities() {
        if (this.driver instanceof HasCapabilities) {
            return ((HasCapabilities)((Object)this.driver)).getCapabilities();
        }
        throw new UnsupportedOperationException("Underlying driver does not implement getting capabilities yet.");
    }

    private class EventFiringAlert
    implements Alert {
        private final Alert alert;

        private EventFiringAlert(Alert alert) {
            this.alert = alert;
        }

        @Override
        public void dismiss() {
            EventFiringWebDriver.this.dispatcher.beforeAlertDismiss(EventFiringWebDriver.this.driver);
            this.alert.dismiss();
            EventFiringWebDriver.this.dispatcher.afterAlertDismiss(EventFiringWebDriver.this.driver);
        }

        @Override
        public void accept() {
            EventFiringWebDriver.this.dispatcher.beforeAlertAccept(EventFiringWebDriver.this.driver);
            this.alert.accept();
            EventFiringWebDriver.this.dispatcher.afterAlertAccept(EventFiringWebDriver.this.driver);
        }

        @Override
        public String getText() {
            return this.alert.getText();
        }

        @Override
        public void sendKeys(String keysToSend) {
            this.alert.sendKeys(keysToSend);
        }
    }

    @Beta
    private class EventFiringWindow
    implements WebDriver.Window {
        private final WebDriver.Window window;

        EventFiringWindow(WebDriver.Window window) {
            this.window = window;
        }

        @Override
        public void setSize(Dimension targetSize) {
            this.window.setSize(targetSize);
        }

        @Override
        public void setPosition(Point targetLocation) {
            this.window.setPosition(targetLocation);
        }

        @Override
        public Dimension getSize() {
            return this.window.getSize();
        }

        @Override
        public Point getPosition() {
            return this.window.getPosition();
        }

        @Override
        public void maximize() {
            this.window.maximize();
        }

        @Override
        public void fullscreen() {
            this.window.fullscreen();
        }
    }

    private class EventFiringTargetLocator
    implements WebDriver.TargetLocator {
        private WebDriver.TargetLocator targetLocator;

        private EventFiringTargetLocator(WebDriver.TargetLocator targetLocator) {
            this.targetLocator = targetLocator;
        }

        @Override
        public WebDriver frame(int frameIndex) {
            return this.targetLocator.frame(frameIndex);
        }

        @Override
        public WebDriver frame(String frameName) {
            return this.targetLocator.frame(frameName);
        }

        @Override
        public WebDriver frame(WebElement frameElement) {
            return this.targetLocator.frame(frameElement);
        }

        @Override
        public WebDriver parentFrame() {
            return this.targetLocator.parentFrame();
        }

        @Override
        public WebDriver window(String windowName) {
            EventFiringWebDriver.this.dispatcher.beforeSwitchToWindow(windowName, EventFiringWebDriver.this.driver);
            WebDriver driverToReturn = this.targetLocator.window(windowName);
            EventFiringWebDriver.this.dispatcher.afterSwitchToWindow(windowName, EventFiringWebDriver.this.driver);
            return driverToReturn;
        }

        @Override
        public WebDriver defaultContent() {
            return this.targetLocator.defaultContent();
        }

        @Override
        public WebElement activeElement() {
            return this.targetLocator.activeElement();
        }

        @Override
        public Alert alert() {
            return new EventFiringAlert(this.targetLocator.alert());
        }
    }

    private class EventFiringTimeouts
    implements WebDriver.Timeouts {
        private final WebDriver.Timeouts timeouts;

        EventFiringTimeouts(WebDriver.Timeouts timeouts) {
            this.timeouts = timeouts;
        }

        @Override
        public WebDriver.Timeouts implicitlyWait(long time, TimeUnit unit) {
            this.timeouts.implicitlyWait(time, unit);
            return this;
        }

        @Override
        public WebDriver.Timeouts setScriptTimeout(long time, TimeUnit unit) {
            this.timeouts.setScriptTimeout(time, unit);
            return this;
        }

        @Override
        public WebDriver.Timeouts pageLoadTimeout(long time, TimeUnit unit) {
            this.timeouts.pageLoadTimeout(time, unit);
            return this;
        }
    }

    private class EventFiringOptions
    implements WebDriver.Options {
        private WebDriver.Options options;

        private EventFiringOptions(WebDriver.Options options) {
            this.options = options;
        }

        @Override
        public Logs logs() {
            return this.options.logs();
        }

        @Override
        public void addCookie(Cookie cookie) {
            this.options.addCookie(cookie);
        }

        @Override
        public void deleteCookieNamed(String name) {
            this.options.deleteCookieNamed(name);
        }

        @Override
        public void deleteCookie(Cookie cookie) {
            this.options.deleteCookie(cookie);
        }

        @Override
        public void deleteAllCookies() {
            this.options.deleteAllCookies();
        }

        @Override
        public Set<Cookie> getCookies() {
            return this.options.getCookies();
        }

        @Override
        public Cookie getCookieNamed(String name) {
            return this.options.getCookieNamed(name);
        }

        @Override
        public WebDriver.Timeouts timeouts() {
            return new EventFiringTimeouts(this.options.timeouts());
        }

        @Override
        public WebDriver.ImeHandler ime() {
            return this.options.ime();
        }

        @Override
        @Beta
        public WebDriver.Window window() {
            return new EventFiringWindow(this.options.window());
        }
    }

    private class EventFiringNavigation
    implements WebDriver.Navigation {
        private final WebDriver.Navigation navigation;

        EventFiringNavigation(WebDriver.Navigation navigation) {
            this.navigation = navigation;
        }

        @Override
        public void to(String url) {
            EventFiringWebDriver.this.dispatcher.beforeNavigateTo(url, EventFiringWebDriver.this.driver);
            this.navigation.to(url);
            EventFiringWebDriver.this.dispatcher.afterNavigateTo(url, EventFiringWebDriver.this.driver);
        }

        @Override
        public void to(URL url) {
            this.to(String.valueOf(url));
        }

        @Override
        public void back() {
            EventFiringWebDriver.this.dispatcher.beforeNavigateBack(EventFiringWebDriver.this.driver);
            this.navigation.back();
            EventFiringWebDriver.this.dispatcher.afterNavigateBack(EventFiringWebDriver.this.driver);
        }

        @Override
        public void forward() {
            EventFiringWebDriver.this.dispatcher.beforeNavigateForward(EventFiringWebDriver.this.driver);
            this.navigation.forward();
            EventFiringWebDriver.this.dispatcher.afterNavigateForward(EventFiringWebDriver.this.driver);
        }

        @Override
        public void refresh() {
            EventFiringWebDriver.this.dispatcher.beforeNavigateRefresh(EventFiringWebDriver.this.driver);
            this.navigation.refresh();
            EventFiringWebDriver.this.dispatcher.afterNavigateRefresh(EventFiringWebDriver.this.driver);
        }
    }

    private class EventFiringWebElement
    implements WebElement,
    WrapsElement,
    WrapsDriver,
    Locatable {
        private final WebElement element;
        private final WebElement underlyingElement;

        private EventFiringWebElement(WebElement element) {
            this.element = (WebElement)Proxy.newProxyInstance(WebDriverEventListener.class.getClassLoader(), EventFiringWebDriver.this.extractInterfaces(element), (proxy, method, args) -> {
                if (method.getName().equals("getWrappedElement")) {
                    return element;
                }
                try {
                    return method.invoke((Object)element, args);
                }
                catch (InvocationTargetException e) {
                    EventFiringWebDriver.this.dispatcher.onException(e.getTargetException(), EventFiringWebDriver.this.driver);
                    throw e.getTargetException();
                }
            });
            this.underlyingElement = element;
        }

        @Override
        public void click() {
            EventFiringWebDriver.this.dispatcher.beforeClickOn(this.element, EventFiringWebDriver.this.driver);
            this.element.click();
            EventFiringWebDriver.this.dispatcher.afterClickOn(this.element, EventFiringWebDriver.this.driver);
        }

        @Override
        public void submit() {
            this.element.submit();
        }

        @Override
        public void sendKeys(CharSequence ... keysToSend) {
            EventFiringWebDriver.this.dispatcher.beforeChangeValueOf(this.element, EventFiringWebDriver.this.driver, keysToSend);
            this.element.sendKeys(keysToSend);
            EventFiringWebDriver.this.dispatcher.afterChangeValueOf(this.element, EventFiringWebDriver.this.driver, keysToSend);
        }

        @Override
        public void clear() {
            EventFiringWebDriver.this.dispatcher.beforeChangeValueOf(this.element, EventFiringWebDriver.this.driver, null);
            this.element.clear();
            EventFiringWebDriver.this.dispatcher.afterChangeValueOf(this.element, EventFiringWebDriver.this.driver, null);
        }

        @Override
        public String getTagName() {
            return this.element.getTagName();
        }

        @Override
        public String getAttribute(String name) {
            return this.element.getAttribute(name);
        }

        @Override
        public boolean isSelected() {
            return this.element.isSelected();
        }

        @Override
        public boolean isEnabled() {
            return this.element.isEnabled();
        }

        @Override
        public String getText() {
            EventFiringWebDriver.this.dispatcher.beforeGetText(this.element, EventFiringWebDriver.this.driver);
            String text = this.element.getText();
            EventFiringWebDriver.this.dispatcher.afterGetText(this.element, EventFiringWebDriver.this.driver, text);
            return text;
        }

        @Override
        public boolean isDisplayed() {
            return this.element.isDisplayed();
        }

        @Override
        public Point getLocation() {
            return this.element.getLocation();
        }

        @Override
        public Dimension getSize() {
            return this.element.getSize();
        }

        @Override
        public Rectangle getRect() {
            return this.element.getRect();
        }

        @Override
        public String getCssValue(String propertyName) {
            return this.element.getCssValue(propertyName);
        }

        @Override
        public WebElement findElement(By by) {
            EventFiringWebDriver.this.dispatcher.beforeFindBy(by, this.element, EventFiringWebDriver.this.driver);
            WebElement temp = this.element.findElement(by);
            EventFiringWebDriver.this.dispatcher.afterFindBy(by, this.element, EventFiringWebDriver.this.driver);
            return EventFiringWebDriver.this.createWebElement(temp);
        }

        @Override
        public List<WebElement> findElements(By by) {
            EventFiringWebDriver.this.dispatcher.beforeFindBy(by, this.element, EventFiringWebDriver.this.driver);
            List<WebElement> temp = this.element.findElements(by);
            EventFiringWebDriver.this.dispatcher.afterFindBy(by, this.element, EventFiringWebDriver.this.driver);
            ArrayList<WebElement> result = new ArrayList<WebElement>(temp.size());
            for (WebElement element : temp) {
                result.add(EventFiringWebDriver.this.createWebElement(element));
            }
            return result;
        }

        @Override
        public WebElement getWrappedElement() {
            return this.underlyingElement;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof WebElement)) {
                return false;
            }
            WebElement other = (WebElement)obj;
            if (other instanceof WrapsElement) {
                other = ((WrapsElement)((Object)other)).getWrappedElement();
            }
            return this.underlyingElement.equals(other);
        }

        public int hashCode() {
            return this.underlyingElement.hashCode();
        }

        public String toString() {
            return this.underlyingElement.toString();
        }

        @Override
        public WebDriver getWrappedDriver() {
            return EventFiringWebDriver.this.driver;
        }

        @Override
        public Coordinates getCoordinates() {
            return ((Locatable)((Object)this.underlyingElement)).getCoordinates();
        }

        @Override
        public <X> X getScreenshotAs(OutputType<X> outputType) throws WebDriverException {
            return this.element.getScreenshotAs(outputType);
        }
    }
}

